#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 09:13:43 2019

@author: yannbrunel
"""

import numpy as np
import matplotlib.pyplot as plt
#%%
x=np.array([0.01,0.41,0.91,1.39,1.86,2.33,2.81,3.33,3.79,4.31,4.83,5.36,5.86,6.34,6.77])
y=np.array([0.01,0.52,1.01,1.42,1.77,2.02,2.16,2.19,2.13,1.96,1.71,1.38,0.97,0.50,0])
t=0.1*np.arange(len(x)) # crée une liste de bonne longueur de valeurs du temps séparées par 0.1
#%%
vxl=[] # initialise un liste vide
m=np.arange(len(t)-2) # redimensionne la liste pour avoir des listes de même longueur
for i in m : #début de la boucle
    vx=(x[i+2]-x[i])/(t[i+2]-t[i]) #construction de la composante horizontale de la vitesse par une méthode à 3 points
    vxl.append(vx) #on ajoute le vx calculé précédemment à la liste vxl

vyl=[] # même principe pour la composante verticale
m=np.arange(len(t)-2)
for i in m :
    vy=(y[i+2]-y[i])/(t[i+2]-t[i])
    vyl.append(vy)
#%%
axl=[] #même démarche pour les composantes de l'accélération
m=np.arange(len(t)-4)
for i in m :
    ax=(vxl[i+2]-vxl[i])/(t[i+2]-t[i])
    axl.append(ax)

ayl=[]
m=np.arange(len(t)-4)
for i in m :
    ay=(vyl[i+2]-vyl[i])/(t[i+2]-t[i])
    ayl.append(ay)


#%%
m=np.arange(1,len(t)-4) #on redimensionne pour avoir des listes de taille correcte
for i in m : # boucle for pour faire tracer point par point 
    plt.arrow(x[i+2],y[i+2],0.1*axl[i],0.1*ayl[i],head_width=0.1) # on affecte les vecteurs accélérations pour les positions correctes
    plt.arrow(x[i+2],y[i+2],0*axl[i],0.1*(0*axl[i]-9.8),fc='r',ec='r',head_width=0.1) # on affecte les vecteurs verticaux modèles
plt.xlim(0,7) # options du graphique
plt.ylim(0,3)
plt.grid()
plt.plot(x,y,'bo-')
plt.xlabel("xreelle")
plt.ylabel("yreelle")
plt.title("Comparaison entre accélération et champ de pesanteur")
plt.show()
#%%    
m=np.arange(0,len(t)-4)
ath=0*m-9.8 # crée une liste nulle de même longueur, pour pouvoir comparer les tracés.
mod=np.polyfit(m,ayl,0) # modélise ayl en fonction de m par une fonction polynomiale d'ordre 0, donc une constante
moda=0*m+mod[0] # crée une liste constante à partir de la modélisation précédente. Sinon, on ne peut pas tracer le modèle. 
plt.plot(m,ayl,'bo-',label="aréelle") # tracé
plt.legend()
plt.grid()
plt.ylim(-20,0)
plt.plot(m,ath,'r-',label="g")
plt.legend()
plt.plot(m,moda,'g-',label="moyenne")
plt.legend()
plt.xlabel("points de la trajectoire")
plt.ylabel("accélération verticale réelle")
plt.title("Comparaison entre accélération et champ de pesanteur")
plt.show()
print(round(mod[0],1)) # renvoie la modélisation correspondante avec un arrondi à 1 CS après la virgule
